﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Net;
using gov.va.med.VBECS.VistaLinkServer.Core;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.VBECS.VistaLinkServer
{
    public class PublishedProcedure
    {
        public PublishedProcedure()
        {
        }

        private string _assemblyNameLocation;

        public PublishedProcedure(IList<RpcParameter> parameters)
        {
            _parameters = parameters;
        }

        private readonly IList<RpcParameter> _parameters;

        public string Name { get; set; }
        public string AssemblyNameLocation
        {
            get
            {
                if (!Path.IsPathRooted(_assemblyNameLocation))
                {
                    // Resolve assembly location fro current directory
                    return Path.Combine(Path.GetDirectoryName(typeof (PublishedProcedure).Assembly.Location) ?? ".",
                                 _assemblyNameLocation);
                }
                return _assemblyNameLocation;
            }
            set { _assemblyNameLocation = value; }
        }

        public string FullTypeName { get; set; }
        public string MethodName { get; set; }
        public IReadOnlyList<RpcParameter> Parameters {
            get { return new ReadOnlyCollection<RpcParameter>(_parameters); }
        }
        public PublishedProcedureSecurityInfo SecurityInfo
        {
            get { return _securityInfo;  }
            set { _securityInfo = value; }
        }

        private PublishedProcedureSecurityInfo _securityInfo = new PublishedProcedureSecurityInfo("VBECS RPC Security", new PublishedProcedureIpAccessList(new ArrayList { IPAddress.Parse("127.0.0.1") }));
    }
}
